<?php
/**********************************************************
* Source Copyright 2014 Author                            *
* Unauthorized reproduction is not allowed                *
* Author: JPK Software Solutions Pvt. Ltd.                *
* Email: sales@visionhelpdesk.com                         *
* Owner: www.visionhelpdesk.com                           *
**********************************************************/
if(!defined('_VIS_')) die('Error: Call from undefined function');
class voip {
    var $error;
	
	function twilio_call($operation){
		global $vis_language;
		$database=new class_database();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket_object=new class_ticket($database);
		
		if(isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1){
			$data= isset($operation['vis_action']) && $operation['vis_action']!='' ? parse_form_array($operation['vis_action']) : $operation;             
		    $operation['vis_domain']=$data['vis_domain_filter'];
		}
		
		$department=$ticket_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		$vis_domain = (!isset($operation['vis_domain'])) ?  $department[0]['domain_id'] : $operation['vis_domain'];
		/*list($vis_all_domain, $twilio_details)=$object->integation_app_availability('27', $vis_domain);*/
		
		$filter='integration_type=27 AND is_enabled=1';
		list($twilio_info, $twilio_domian_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
		
		if($twilio_domian_details==-1) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
			return false;
		}
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
		list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
       
		$limit = $view_info['page_count'];//SECURITY_DATA_PER_PAGE;
		$page = (isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page']:0;
		
	    try {
			$data['start'] = $page; $data['limit'] = $limit;
			$twilio_call_list = $voip_object->get_twilio_call($twilio_domian_details[0]['host_name'], $twilio_domian_details[0]['user_name'], $twilio_domian_details[0]['db_name'], $data);
			$num_pages=$twilio_call_list->num_pages;$num_pages=2;
		}catch (Exception $e) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
			return false;
		}
		$total_twilio_call = ($twilio_call_list->calls)?count($twilio_call_list->calls):0;
		//echo "<pre>";print_r($twilio_call_list);echo "</pre>";
		if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
			ob_start();
			include(VIS_PATH_TEMPLATE.'twilio_call_list.php');
			$twilio_list = ob_get_clean();
			ob_end_flush();	
			$data_live = ($num_pages > 10) ? 'data-live-search="true"': '';
						
			$select='';
			$select .= "<div class=\"pull-right\">";
			$select .= "<select name=\"pageing\" id=\"paging\" class=\"form-control input-sm selectpicker pull-right paging v-middle\" ".$data_live." onchange=\"javascript:vis_apply_filter(this.value);\">";					  
			for($i=0;$i<$num_pages;$i++)
				$select.='<option value="'.$i.'" '.(($page==$i)?'selected="selected"':'').'>'.($i+1).'</option>';
			$select .= "</select><div class=\"text-muted pull-right label_page\">".$vis_language['TXTPAGE'].":</div>";
			$select .='<script>$(".selectpicker").selectpicker();</script>';
			
			$select2='';
			$data_domain_live = ($department > 10) ? 'data-live-search="true"': '';
			$select2 .= "<select name=\"vis_domain\" id=\"vis_domain\" class=\"form-control selectpicker\" ".$data_domain_live." onchange=\"javascript:vis_change_domain(this.value);\">";
			for($j=0;$j<count($department);$j++){
				 if($vis_domain == $department[$j]['domain_id'])$chk = 'selected="selected"';
				 else $chk = '';
				
				if($vis_all_domain!=1){
					for($l=0;$l<count($twilio_domian_details);$l++){
						if($twilio_domian_details[$l]['domain_id'] == $department[$j]['domain_id']){ 
							$select2 .= '<option '.$chk.' value="'.$department[$j]['domain_id'].'">'.$department[$j]['domain_name'].'</option>'; 
						}
					}
				}else $select2 .= '<option '.$chk.' value="'.$department[$j]['domain_id'].'">'.$department[$j]['domain_name'].'</option>';
			 }
			$select2 .='</select><script>$(".selectpicker").selectpicker();</script>';					 
			echo json_encode( array('total_cnt'=>$total_twilio_call, 'paging' => $select, 'domain' => $select2, 'list'=> $twilio_list ,'title'=> ''));
		}else{
			if((isset($operation['vis_domain']) || isset($operation['vis_filter_enable'])) && isset($operation['vis_page']))
				include(VIS_PATH_TEMPLATE.'twilio_call_list.php');
			else
				include(VIS_PATH_TEMPLATE.'twilio_call.php');			
			return true;
		}
	}
	
	function twilio_call_details($operation){
        global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        $vis_domain = $operation['vis_chk_domain'];
		$vis_call_id = $operation['vis_call_id'];
		
         if(isset($vis_domain) && $vis_domain!='' && isset($vis_call_id) && $vis_call_id!='') {
			list($vis_all_domain, $twilio_details)=$object->integation_app_availability('27', $vis_domain);
			if($twilio_details==-1) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
				return false;
			}else{
				 try {
					$twilio_call_details = $voip_object->get_twilio_call_details($twilio_details[0]['host_name'], $twilio_details[0]['user_name'], $twilio_details[0]['db_name'], $vis_call_id);
					$twilio_call_recording = $voip_object->get_recording($twilio_details[0]['host_name'], $twilio_details[0]['user_name'], $twilio_details[0]['db_name'], $vis_call_id);
					include(VIS_PATH_TEMPLATE.'twilio_call_details.php');
				}catch (Exception $e) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
					return false;
				}
			}
		}
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
    }
    
    function twilio_new_call($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
				
		$twilio_number = $voip_object->get_twilio_number(' is_outbound=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(isset($operation['vis_to_number']))$operation['vis_to_number'] = "+".$operation['vis_to_number'];
		include(VIS_PATH_TEMPLATE.'twilio_new_call.php');
		return true;
	}
    
    function twilio_make_call($operation){
		global $vis_language;
		$database=new class_database();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		$data= isset($operation['vis_action']) && $operation['vis_action']!='' ? parse_form_array($operation['vis_action']) : $operation;
		if(!isset($data['vis_call_number']) || $data['vis_call_number']=='' || !isset($data['vis_twilio_number']) || $data['vis_twilio_number']=='0') {
			echo json_encode( array('status'=>'300', 'message'=>''));
		}else{
			$twilio_call_details = $voip_object->make_twilio_call($data);
			echo $twilio_call_details;
		}
	}
	
	function twilio_hangup_call($operation){
		global $vis_language;
		$database=new class_database();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		
		list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$vis_domain = (!isset($operation['vis_domain'])) ?  $department[0]['domain_id'] : $operation['vis_domain'];
		
		list($vis_all_domain, $twilio_details)=$object->integation_app_availability('27', $vis_domain);
		if($twilio_details==-1) {
			echo json_encode( array('status'=>'400', 'message'=>$vis_language['MSGERROPRT']));
		}else{
			$data= isset($operation['vis_action']) && $operation['vis_action']!='' ? parse_form_array($operation['vis_action']) : $operation;             
			$twilio_call_details = $voip_object->hangup_twilio_call($twilio_details[0], $data);
			echo $twilio_call_details;
		}
	}
	
    function twilio_message($operation){
		global $vis_language;
		$database=new class_database();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket_object=new class_ticket($database);
		if(isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1){
			$data= isset($operation['vis_action']) && $operation['vis_action']!='' ? parse_form_array($operation['vis_action']) : $operation;             
		    $operation['vis_domain']=$data['vis_domain_filter'];
		}
		
		$department=$ticket_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$vis_domain = (!isset($operation['vis_domain'])) ?  $department[0]['domain_id'] : $operation['vis_domain'];
		
		$filter='integration_type=27 AND is_enabled=1';
		list($twilio_info, $twilio_domian_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id asc');
		
		list($vis_all_domain, $twilio_details)=$object->integation_app_availability('27', $vis_domain);
		
		if($twilio_details==-1) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
			return false;
		}
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
		list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
       
		$limit = $view_info['page_count'];//SECURITY_DATA_PER_PAGE;
		$page = (isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page']:0;
		
	    try {
			$data['start'] = $page; $data['limit'] = $limit;
			$twilio_msg_list = $voip_object->get_twilio_message($twilio_details[0]['host_name'], $twilio_details[0]['user_name'], $twilio_details[0]['db_name'], $data);
			$num_pages=$twilio_msg_list->num_pages;
		}catch (Exception $e) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
			return false;
		}
		//echo "<pre>";print_r($twilio_msg_list);echo "</pre>";
		$total_twilio_msg = ($twilio_msg_list->messages)?count($twilio_msg_list->messages):0;
		if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
			ob_start();
			include(VIS_PATH_TEMPLATE.'twilio_message_list.php');
			$twilio_list = ob_get_clean();
			ob_end_flush();
			$data_live = ($num_pages > 10) ? 'data-live-search="true"': '';			
			$select='';
			$select .= "<div class=\"pull-right\">";
			$select .= "<select name=\"pageing\" id=\"paging\" class=\"form-control input-sm selectpicker pull-right paging v-middle\" ".$data_live." onchange=\"javascript:vis_apply_filter(this.value);\">";					  
			for($i=0;$i<$num_pages;$i++)
				$select.='<option value="'.$i.'" '.(($page==$i)?'selected="selected"':'').'>'.($i+1).'</option>';
			$select .= "</select><div class=\"text-muted pull-right label_page\">".$vis_language['TXTPAGE'].":</div>";
			$select .='<script>$(".selectpicker").selectpicker();</script>';
			
			$select2='';
			$data_domain_live = ($department > 10) ? 'data-live-search="true"': '';
			$select2 .= "<select name=\"vis_domain\" id=\"vis_domain\" class=\"form-control selectpicker\" ".$data_domain_live." onchange=\"javascript:vis_change_domain(this.value);\">";
			for($j=0;$j<count($department);$j++){
				 if($vis_domain == $department[$j]['domain_id'])$chk = 'selected="selected"';
				 else $chk = '';
				
				if($vis_all_domain!=1){
					for($l=0;$l<count($twilio_domian_details);$l++){
						if($twilio_domian_details[$l]['domain_id'] == $department[$j]['domain_id']){ 
							$select2 .= '<option '.$chk.' value="'.$department[$j]['domain_id'].'">'.$department[$j]['domain_name'].'</option>'; 
						}
					}
				}else $select2 .= '<option '.$chk.' value="'.$department[$j]['domain_id'].'">'.$department[$j]['domain_name'].'</option>';
			 }
			$select2 .='</select><script>$(".selectpicker").selectpicker();</script>';
			echo json_encode( array('total_cnt'=>$total_twilio_msg, 'paging' => $select, 'domain' => $select2, 'list'=> $twilio_list ,'title'=> ''));
		}else{
			if((isset($operation['vis_domain']) || isset($operation['vis_filter_enable'])) && isset($operation['vis_page']))
				include(VIS_PATH_TEMPLATE.'twilio_message_list.php');
			else
				include(VIS_PATH_TEMPLATE.'twilio_message.php');			
			return true;
		}
	}
	
	function twilio_message_details($operation){
        global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		       
	    $vis_domain = $operation['vis_chk_domain'];
		$vis_msg_id = $operation['vis_msg_id'];
         if(isset($vis_domain) && $vis_domain!='' && isset($vis_msg_id) && $vis_msg_id!='') {
			list($vis_all_domain, $twilio_details)=$object->integation_app_availability('27', $vis_domain);
			if($twilio_details==-1) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
				return false;
			}else{
				 try {
					$twilio_message_details = $voip_object->get_twilio_msg_details($twilio_details[0]['host_name'], $twilio_details[0]['user_name'], $twilio_details[0]['db_name'], $vis_msg_id);
					include(VIS_PATH_TEMPLATE.'twilio_message_details.php');
				}catch (Exception $e) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
					return false;
				}
			}
		}
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
    }
    
    function new_twilio_message($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		
		$twilio_number = $voip_object->get_twilio_number(' is_outbound=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		include(VIS_PATH_TEMPLATE.'twilio_new_msg.php');
		return true;
	}
	function send_twilio_msg($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
		
		if($data['vis_to_num']=='' || $data['vis_message']=='' || $data['vis_twilio_number']==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");</script>';
            return false;
        }
		
		try {
			$twilio_message_details = $voip_object->send_twilio_msg($data);
			if($twilio_message_details->status=='400'){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$twilio_message_details->message.'");</script>';
				return false;
			}else{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$(".modal").modal("toggle"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTWILIOMSG'].'",{"vis_module":"voip", "vis_operation":"twilio_message"}); </script>';
				return true;
			}
			
		}catch (Exception $e) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
			return false;
		}
	}
	function twilio_incoming_call($operation){
		$database=new class_database();
        global $vis_language;
        $filter='';
        if(isset($operation['incoming_call_from']) && $operation['incoming_call_from']!='') 
		$filter='contact_number = "'.$operation['incoming_call_from'].'"';
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'client.php');
        $client_object=new class_client($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		
		$twilio_number_details = $voip_object->get_twilio_number_details($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
        list($client_info, $client_details)=$client_object->get_client($filter, '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		//include(VIS_PATH_TEMPLATE.'twilio_incoming_call.php');
		if($client_details!=-1){
			$href = '#/client/client_details/'.$client_details[0]['first_name'].' '.$client_details[0]['last_name'].'/'.$client_details[0]['client_id'];
			$client_img = $client_details[0]['domain_url'].'awatar/'.VIS_PATH_PROFILE;
			$client_img .= ($client_details[0]['image_path']=='')?'default.jpg':$client_details[0]['image_path'];
			$domain_name = $client_details[0]['domain_name'];
		}else{
			$href = '#';
			$client_img = VIS_PATH_PROFILE.'default.jpg';
			$domain_name = '';
		}
		$data = '<a href="'.$href.'" class="thumb-md pull-left m-r"><img src="'.$client_img.'" id="twilio_profile_img" class="img-circle b-a b-3x b-light"></a><div class="clear m-t"><a href="'.$href.'" class="text-info h4">'.$client_details[0]['first_name'].' '.$client_details[0]['last_name'].'</a><small class="block text-muted" id="twilio_incoming_call_number">'.$operation['incoming_call_from'].'</small><small class="h5" id="caller_company">'.$domain_name.'</small></div>';
		echo json_encode( array('twilio_data'=>$data, 'to_number'=>$twilio_number_details['twilio_title']));
		return true;
	}
	function twilio_forword_to($operation){
		global $vis_language;
		$database=new class_database();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		$forward_details=$voip_object->get_staff_forward(VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		include(VIS_PATH_TEMPLATE.'twilio_forword_to.php');
		return true;
	}
	function update_forword_to($operation){
		global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
        $data=parse_form_array($operation['vis_action']);
		
        if($data['vis_forword_to_number'] == '') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");</script>';
            return false;
        }
        
        $res = $voip_object->update_forword_to($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$forward_details=$voip_object->get_staff_forward(VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$res) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        }
        else {
			$color_class = ($forward_details!=-1 && $forward_details[0]['forward_number']!='') ? 'yellow' : (($forward_details[0]['status']=='0')? 'red':'green');
			$details = '<a href="javascript:void(0);"><i class="vh vh-mail-forward vh-yellow m-t-sm"></i> '.$data['vis_forword_to_number'].'</a><a href="javascript:void(0);" style="float:right;margin-top:-36px"  onclick="javascript:remove_twilio_forward();"><i class="vh vh-cross m-t-sm"></i></a>';
			echo '<script>$("#vis_twilio_forward_to_details").show();$("#call_color_icon").html(\'<span class="vh-call-box '.$color_class.'"></span>\'); $("#vis_twilio_forward_to_details").html(\''.$details.'\'); $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$(".modal").modal("toggle"); </script>';
		}
        return true;
	}
	function remove_twilio_forward($operation){
		if($operation['vis_remove_forward']==1){
			global $vis_language;
			$database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
			$voip_object=new class_voip($database);
			$color_class ='';$status='success';
			$res = $voip_object->remove_forword_to(VIS_STAFF_ID, VIS_LOCATION_AREA);
			$forward_details=$voip_object->get_staff_forward(VIS_STAFF_ID, VIS_LOCATION_AREA);
			$color_class = ($forward_details!=-1 && $forward_details[0]['forward_number']!='') ? 'yellow' : (($forward_details[0]['status']=='0')? 'red':'green');
			if(!$res) {
				$color_class ='';
				$status='error';
			}
			echo json_encode( array('status'=>$status, 'color' => $color_class));
	        return true;
		}
	}
	function update_twilio_staff_status($operation){
		global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		$color_class ='';$status='success';
        if(isset($operation['vis_status'])){
			$res = $voip_object->update_twilio_staff_status($operation['vis_status'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			$forward_details=$voip_object->get_staff_forward(VIS_STAFF_ID, VIS_LOCATION_AREA);
			$color_class = ($forward_details!=-1 && $forward_details[0]['forward_number']!='') ? 'yellow' : (($forward_details[0]['status']=='0')? 'red':'green');
			if(!$res) {
				$color_class ='';
				$status='error';
			}
	   }else{
		   $status='error';
		}
	   echo json_encode( array('status'=>$status, 'color' => $color_class));
	   return true;
	}
	
	##Exotel
	//show call connect template page
	 function connect_customer_to_agent($operation) {
        global $vis_language;		
        $database=new class_database();        
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'client.php');
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php'); 
		
        $client_obj=new class_client($database);
        $setting_obj=new class_setting($database);
		
		$exotel_filter='integration_type=38 AND is_enabled=1';
	    list($exo_count, $exotel_details)=$setting_obj->get_integration_setting($exotel_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);		
        $exotel_details=$exotel_details[0];
		
		 list($number_count, $exotel_apps)=$setting_obj->get_exotel_apps(VIS_TABLE_PREFIX.'exotel_apps.integration_id ='.$exotel_details['integration_id'], $limit, $page, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		$query = "SELECT `mobile_number`,`contact_number` FROM `avis_staff` WHERE  `staff_id` = ".VIS_STAFF_ID;
        $result=$database->query_exec($query);
		$mobile=$database->fetch_result($result); 
        $frm_no = ($mobile['mobile_number']!='')?$mobile['mobile_number']:$mobile['contact_number'];
		
		
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'exo_call.php');
        return true;
    }
	//connect actual call
	function connect_agent_call($operation){
		global $vis_language;		
        $database=new class_database(); 
        $data=parse_form_array($operation['vis_action']);       
        if(trim($data['vis_app'])=='' || trim($data['vis_app'])== 0){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSELECTAPP'].'"); </script>';
            return false;
		}
		if(trim($data['vis_callerid'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSELECTCAllER'].'"); </script>';
            return false;
        } 
		if(trim($data['vis_from'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGFROM'].'"); </script>';
            return false;
        } 
		if(trim(strip_tags($data['vis_to']))=='' || trim($data['vis_to'])== 0 || urldecode(trim($data['vis_to']))=='' ) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGTO'].'"); </script>';
            return false;
        }
		
		include_once(VIS_PATH_PLUGINS.'exotel/class_exotel.php'); ##exotel integration	
	    $obj_exotel	=	new class_exotel();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php'); 
		$setting_obj=new class_setting($database);
		
		$post_data	 = array(
							'From' => $data['vis_from'], //agent
							'To' => $data['vis_to'], //customer
							'CallerId' => $data['vis_callerid'],
							'TimeLimit' => $data['vis_timelimit'],
							'TimeOut' => $data['vis_timeout'],
							'CallType' => $data['vis_call_type'] //Can be "trans" for transactional and "promo" for promotional content
							);
							
		$exotel_filter='integration_type=38 AND is_enabled=1';		
	    list($exo_count, $exotel_details)=$setting_obj->get_integration_setting($exotel_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);		
        $exotel_details=$exotel_details[0];	
		$exo_data = array("exotel_sid"=>$exotel_details['host_name'],
						"exotel_token"=>$exotel_details['user_name'],
						"post_data" =>$post_data,
					 );
					 
	   $ret = $obj_exotel->connect_call($exo_data);
	   $respo = json_encode($ret,true);
	   //print_r($ret);
	   if(isset($ret['RestException'])){
		   echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $ret['RestException']['Message'].'"); </script>';
          return false;
	   }else{
			$insId = $setting_obj->add_exo_call_details($ret['Call']['Sid'],$respo,'1',VIS_STAFF_ID,VIS_DOMAIN,0,$ret['Call']['From'],$ret['Call']['To'], VIS_LOCATION_AREA);		   
			 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $(".modal").modal("toggle"); </script>';	
			//$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTEXOTELAPPS'].'",{"vis_module":"voip", "vis_operation":"get_call_detail_view","vis_action":"#/voip/get_call_detail_view/call details/'.$insId.'"});			 
			return true;
	   }   
		
	}
	//get callerid using ajax call
	function get_caller_id($operation) { 
        global $vis_language;		
        $database=new class_database();           
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');       
        $setting_obj=new class_setting($database);	
		
		list($number_count, $exotel_apps)=$setting_obj->get_exotel_apps(VIS_TABLE_PREFIX.'exotel_apps.exotel_id ='.$operation['vis_exotel_id'], $limit, $page, '', VIS_STAFF_ID, VIS_LOCATION_AREA);   
		$database->database_disconnect();    		
		$exophones = $exotel_apps[0]['exophones'];
		$exophones_arr = explode(',',$exophones);		
		echo '<select name="vis_callerid" id="vis_callerid" class="form-control input-sm selectpicker"  data-live-search="true"  >';	
		for($i=0;$i<count($exophones_arr);$i++){
			echo '<option value="'.$exophones_arr[$i].'">'.$exophones_arr[$i].'</option>';
		}
		echo '</select>';          
        return true;
    }
	//call listing			
	function exotel_call($operation) { 
        global $vis_language;
		$database=new class_database();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket_object=new class_ticket($database);
		include_once(VIS_PATH_PLUGINS.'exotel/class_exotel.php'); ##exotel integration	
	    $obj_exotel	=	new class_exotel();		
		
		$filter='integration_type=38 AND is_enabled=1';
		list($exotel_info, $exotel_domian_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id desc');
		
		if($exotel_domian_details==-1) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
			return false;
		}
		
		$exo_data = array("exotel_sid"=>$exotel_domian_details[0]['host_name'],
						  "exotel_token"=>$exotel_domian_details[0]['user_name'],						
					 );
		$limit = 5;			 
		if(isset($operation['vis_page'])&$operation['vis_page']!=''){
			$start = ($operation['vis_page']-1)*$limit;
			$exotel_sid = $voip_object->get_exo_call_details("ORDER BY id desc",0,$start,$limit);
		}else{			 
			$exotel_sid = $voip_object->get_exo_call_details("ORDER BY id desc",0,0,$limit);	
		}		
		$call_details = array();
		
		for($i=0;$i<count($exotel_sid);$i++){
			$call_sid = $exotel_sid[$i]['sid'];
			$call_details[] = $obj_exotel->get_call_details($call_sid,$exo_data);
		}
		
		$total_exotel_call = (isset($call_details))?count($call_details):0;
		
		$exo_count = $voip_object->get_exo_call_details_count();
				
		$pages = ceil(($exo_count[0]['COUNT(*)']/$limit));
		$paging_list ='';
		for($i=0;$i<$pages;$i++){
			$selected = ($operation['vis_page']==($i+1))? ' selected="selected" ': '';
			$paging_list .= '<option '.$selected.' >'.($i+1).'</option>';
		}		
        include(VIS_PATH_TEMPLATE.'exo_call_list.php');
        return true;
    }	
	function exotel_call_details($operation){ 
		global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        $vis_domain = $operation['vis_chk_domain'];
		$call_sid = $action[4];
		
		include_once(VIS_PATH_PLUGINS.'exotel/class_exotel.php'); ##exotel integration	
	    $obj_exotel	=	new class_exotel();		
		$exotel_filter='integration_type=38 AND is_enabled=1';		
	    list($exo_count, $exotel_details)=$object->get_integration_setting($exotel_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);		
        $exotel_details=$exotel_details[0];
		$exo_data = array("exotel_sid"=>$exotel_details['host_name'],
						  "exotel_token"=>$exotel_details['user_name'],
						 );
		$call_details = $obj_exotel->get_call_details($call_sid,$exo_data);
		//echo'<pre>';print_r($call_details); echo '</pre>';
       
			if($exotel_details==-1) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
				return false;
			}else{				
				 include(VIS_PATH_TEMPLATE.'exotel_call_details.php');
				}     
		
	}
	
	function connect_customer_to_flow($operation) {
	}
	function sms_send_view($operation){
		global $vis_language;		
        $database=new class_database();        
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'client.php');
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php'); 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		
        $client_obj=new class_client($database);
        $setting_obj=new class_setting($database);
		$ticket=new class_ticket($database);
		
		$filter= (VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');

		if(VIS_LOCATION_AREA==2 && isset($operation['vis_domain_id']) && $operation['vis_domain_id']!='') $filter.=' and '.VIS_TABLE_PREFIX.'department.domain_id='.$operation['vis_domain_id'];

		if(isset($operation['vis_client']) && $operation['vis_client']==1)
        $filter.=' and '.VIS_TABLE_PREFIX.'domain.domain_id='.$operation['vis_domain_id'];
	
		$departments=$ticket->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, '');
		
		$exotel_filter='integration_type=38 AND is_enabled=1';
	    list($exo_count, $exotel_details)=$setting_obj->get_integration_setting($exotel_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);		
        $exotel_details=$exotel_details[0];
		
		 list($number_count, $exotel_apps)=$setting_obj->get_exotel_apps(VIS_TABLE_PREFIX.'exotel_apps.integration_id ='.$exotel_details['integration_id'], $limit, $page, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		$query = "SELECT `mobile_number`,`contact_number` FROM `avis_staff` WHERE  `staff_id` = ".VIS_STAFF_ID;
        $result=$database->query_exec($query);
		$mobile=$database->fetch_result($result); 
        $frm_no = ($mobile['mobile_number']!='')?$mobile['mobile_number']:$mobile['contact_number'];	
		
        $database->database_disconnect();
		
		//vis_call_type 
        include(VIS_PATH_TEMPLATE.'exo_sms.php');
        return true;
	}
	
	function send_exo_sms($operation) { //send both single & bulk sms		
		global $vis_language;		
        $database=new class_database(); 
        $data=parse_form_array($operation['vis_action']);  
		if($operation['vis_call_type']==4) { 		
			if(trim($data['vis_app'])=='' || trim($data['vis_app'])== 0){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSELECTAPP'].'"); </script>';
				return false;
			}
			if(trim($data['vis_callerid'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSELECTCAllER'].'"); </script>';
				return false;
			} 
		}
		if($operation['vis_call_type']==3) { 
			if(trim($data['vis_from'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGFROM'].'"); </script>';
				return false;
			} 
		}
		if(trim(strip_tags($data['vis_to']))=='' || trim($data['vis_to'])== 0 || urldecode(trim($data['vis_to']))=='' ) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGTO'].'"); </script>';
            return false;
        }
		if(trim(strip_tags($data['vis_msg_body']))=='' || urldecode(trim($data['vis_msg_body']))=='' ) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGBODY'].'"); </script>';
            return false;
        }
		 
		include_once(VIS_PATH_PLUGINS.'exotel/class_exotel.php'); ##exotel integration	
	    $obj_exotel	=	new class_exotel();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php'); 
		$setting_obj=new class_setting($database);
		$exotel_filter='integration_type=38 AND is_enabled=1';		
	    list($exo_count, $exotel_details)=$setting_obj->get_integration_setting($exotel_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);		
        $exotel_details=$exotel_details[0];		
		$post_data	 = array(
							'From' => $data['vis_from'], //agent
							'To' => $data['vis_to'], //customer
							'Body' => $data['vis_msg_body'],							
							);	

		if($operation['vis_call_type']==3) { // normal sms	
			$post_data	 = array(
							'From' => $data['vis_from'], //agent
							'To' => $data['vis_to'], //customer
							'Body' => $data['vis_msg_body'],							
							);
		}else if($operation['vis_call_type']==4) { //bulk sms
			$bulk_contacts  = str_replace(' ','',$data['vis_to']);
			$bulk_contacts  = explode(',',$bulk_contacts);
			$post_data	 	= array(
								'From' => $data['vis_callerid'], //callerid
								'To' => $bulk_contacts, //bulk customer array
								'Body' => $data['vis_msg_body'],							
								);
		}					
		
		$exo_data = array("exotel_sid"=>$exotel_details['host_name'],
						"exotel_token"=>$exotel_details['user_name'],
						"post_data" =>$post_data,
					 );
	
	   $ret = $obj_exotel->send_sms($exo_data); 
	   $respo = json_encode($ret,true);
	   
	   if(isset($ret['RestException'])){
		   echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $ret['RestException']['Message'].'"); </script>';
          return false;
	   }else{ 
				if($ret!=-1){
					if(count($bulk_contacts)==1 || !isset($bulk_contacts) || $bulk_contacts==''){
						$Sid = $ret['SMSMessage']['Sid'];
						$To = $ret['SMSMessage']['To'];
						$AccountSid = $ret['SMSMessage']['AccountSid'];
						$From = $ret['SMSMessage']['From'];
						
						$setting_obj->add_exo_call_details($Sid,$respo,'1',VIS_STAFF_ID,VIS_DOMAIN,1,$From,$To, VIS_LOCATION_AREA,$data['vis_department']);
					}else{
						for($i=0;$i<count($ret['SMSMessage']);$i++){
							$Sid = $ret['SMSMessage'][$i]['Sid'];
							$To = $ret['SMSMessage'][$i]['To'];
							$AccountSid = $ret['SMSMessage'][$i]['AccountSid'];
							$From = $ret['SMSMessage'][$i]['From'];
							
							$setting_obj->add_exo_call_details($Sid,$respo,'1',VIS_STAFF_ID,VIS_DOMAIN,1,$From,$To, VIS_LOCATION_AREA,$data['vis_department']);
										
						}
					}								
					 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $(".modal").modal("toggle"); </script>';						 
					return true;
				}else{
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTAUTHENTICATIONERROR'].'"); </script>';
					return false;
				}
	   }  
	}    
	
	//message listing			
	function exotel_message($operation) { 
        global $vis_language;
		$database=new class_database();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket_object=new class_ticket($database);
		include_once(VIS_PATH_PLUGINS.'exotel/class_exotel.php'); ##exotel integration	
	    $obj_exotel	=	new class_exotel();		
		
		$filter='integration_type=38 AND is_enabled=1';
		list($exotel_info, $exotel_domian_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id desc');
		
		if($exotel_domian_details==-1) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
			return false;
		}
		
		$exo_data = array("exotel_sid"=>$exotel_domian_details[0]['host_name'],
						  "exotel_token"=>$exotel_domian_details[0]['user_name'],						
					 );
		$limit = 5;			 
		if(isset($operation['vis_page'])&$operation['vis_page']!=''){
			$start = ($operation['vis_page']-1)*$limit;
			$exotel_sid = $voip_object->get_exo_call_details("ORDER BY id desc",1,$start,$limit);
		}else{			 
			$exotel_sid = $voip_object->get_exo_call_details("ORDER BY id desc",1,0,$limit);	
		}		
		$call_details = array();
		
		for($i=0;$i<count($exotel_sid);$i++){
			$call_sid = $exotel_sid[$i]['sid'];
			$call_details[] = $obj_exotel->get_sms_details($call_sid,$exo_data);
		}
		$total_exotel_call = (isset($call_details))?count($call_details):0;
		
		$exo_count = $voip_object->get_exo_call_details_count(1);
				
		$pages = ceil(($exo_count[0]['COUNT(*)']/$limit));
		$paging_list ='';
		for($i=0;$i<$pages;$i++){
			$selected = ($operation['vis_page']==($i+1))? ' selected="selected" ': '';
			$paging_list .= '<option '.$selected.' >'.($i+1).'</option>';
		}		
        include(VIS_PATH_TEMPLATE.'exo_message_list.php'); 
        return true;
    }
	function exotel_message_details($operation){ 
		global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        $vis_domain = $operation['vis_chk_domain'];
		$call_sid = $action[4];
		
		include_once(VIS_PATH_PLUGINS.'exotel/class_exotel.php'); ##exotel integration	
	    $obj_exotel	=	new class_exotel();		
		$exotel_filter='integration_type=38 AND is_enabled=1';		
	    list($exo_count, $exotel_details)=$object->get_integration_setting($exotel_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);		
        $exotel_details=$exotel_details[0];
		$exo_data = array("exotel_sid"=>$exotel_details['host_name'],
						  "exotel_token"=>$exotel_details['user_name'],
						 );
		$call_details = $obj_exotel->get_sms_details($call_sid,$exo_data);
		//echo'<pre>';print_r($call_details); echo '</pre>';
       
			if($exotel_details==-1) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
				return false;
			}else{				
				 include(VIS_PATH_TEMPLATE.'exotel_sms_details.php');
				}     
		
	}
	
	###Exotel
	
	##Aircall
	
	function aircall_call($operation) { 
		$action = explode('/',$operation['vis_action']);
        global $vis_language;
		$database=new class_database();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket_object=new class_ticket($database);
		include_once(VIS_PATH_PLUGINS.'aircall/class_aircall.php'); ##aircall integration	
	    $obj_aircall	=	new class_aircall();		
		$action_arr = explode('&',$action[4]);
		
		$filter='integration_type=50 AND is_enabled=1 ';
		list($all_aircall_info, $all_aircall_domian_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id desc');
		$dom_list =array();
		for($d=0;$d<count($all_aircall_domian_details);$d++){
			$dom_list[] = $all_aircall_domian_details[$d]['domain_id'];
		}
		$k = array_search('0',$dom_list);
		if(trim($k)!==''){ unset($dom_list[$k]); }
		sort($dom_list); 
		$dom_id = (in_array(0,$dom_list))?0:$dom_list[0];			
		$dom_id = (isset($action_arr[1])&&$action_arr[1]!='')?$action_arr[1]:$dom_id;

		$str_dom_list = implode(',',$dom_list);
		list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1 AND '.VIS_TABLE_PREFIX.'domain.domain_id IN('.$str_dom_list.')', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);


		$filter='integration_type=50 AND is_enabled=1 AND domain_id='.$dom_id;
		list($aircall_info, $aircall_domian_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id desc');
		
		if($aircall_domian_details==-1) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
			return false;
		}
		
		$apiId = $aircall_domian_details[0]['host_name'];
		$apiToken = $aircall_domian_details[0]['user_name'];
		
		$page = ($action_arr[0]>0)?$action_arr[0]:1;
		$per_page = 20;
		$order = 'desc';		
		
		$call_details = $obj_aircall->get_aircall($apiId,$apiToken,'/calls?page='.$page.'&per_page='.$per_page.'&order='.$order);
		//echo '<pre>';print_r($call_details);echo '</pre>';


		$aircall_count = $call_details[0]->meta->count;
		
		//$limit = 5;					
		//$call_details = array();	
		
		//$total_exotel_call = (isset($call_details))?count($call_details):0;
		
		//$exo_count = $voip_object->get_exo_call_details_count();				
		//$pages = ceil(($exo_count[0]['COUNT(*)']/$limit));
		$paging_list ='';
		/*for($i=0;$i<$pages;$i++){
			$selected = ($operation['vis_page']==($i+1))? ' selected="selected" ': '';
			$paging_list .= '<option '.$selected.' >'.($i+1).'</option>';
		}*/			
        include(VIS_PATH_TEMPLATE.'aircall_call_list.php');
        return true;
    }

	function aircall_call_details($operation){ 
		global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        $vis_domain = $operation['vis_chk_domain'];
		$call_id = trim($action[4]);
		
		include_once(VIS_PATH_PLUGINS.'aircall/class_aircall.php'); ##aircall integration	
	    $obj_aircall	=	new class_aircall();	
		 
		$aircall_filter='integration_type=50 AND is_enabled=1 AND domain_id='.$operation['vis_domain_id'];		
	    list($aircall_count, $aircall_details)=$object->get_integration_setting($aircall_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);		
        $aircall_details=$aircall_details[0];
		
		$apiId = $aircall_details['host_name'];
		$apiToken = $aircall_details['user_name'];
		
		$call_details = $obj_aircall->get_aircall($apiId,$apiToken,'/calls/'.$call_id);
		//echo '<pre>';print_r($call_details);echo '</pre>';
		      
			if($aircall_details==-1) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
				return false;
			}else{				
				 include(VIS_PATH_TEMPLATE.'aircall_call_details.php');
				}     
		
	}
	###Aircall
	
	##Asterisk
	function asterisk_call($operation) { 
		$action = explode('/',$operation['vis_action']);
        global $vis_language;
		$database=new class_database();
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket_object=new class_ticket($database);
		include_once(VIS_PATH_PLUGINS.'aircall/class_aircall.php'); ##aircall integration	
	    $obj_aircall	=	new class_aircall();		
		$action_arr = explode('&',$action[4]);
		
		$filter='integration_type=51 AND is_enabled=1 ';
		list($all_asterisk_info, $all_asterisk_domian_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id desc');
		$dom_list =array();
		for($d=0;$d<count($all_asterisk_domian_details);$d++){
			$dom_list[] = $all_asterisk_domian_details[$d]['domain_id'];
		} 
		$k = array_search('0',$dom_list);
		if(trim($k)!==''){ unset($dom_list[$k]); }
		sort($dom_list); 
		$dom_id = (in_array(0,$dom_list))?0:$dom_list[0];			
		$dom_id = (isset($action_arr[1])&&$action_arr[1]!='')?$action_arr[1]:$dom_id;

		$str_dom_list = implode(',',$dom_list);
		list($dpinf, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1 AND '.VIS_TABLE_PREFIX.'domain.domain_id IN('.$str_dom_list.')', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);


		$filter='integration_type=51 AND is_enabled=1 AND domain_id='.$dom_id;
		list($asterisk_info, $asterisk_domian_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'order by domain_id desc');
		
		if($asterisk_domian_details==-1) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
			return false;
		}
		
		 $db_host_name	= $asterisk_domian_details[0]['host_name'];
		 $db_user_name	= $asterisk_domian_details[0]['user_name'];
		 $db_password	= $asterisk_domian_details[0]['db_password'];
		 $db_name		= $asterisk_domian_details[0]['db_name'];
		 $con = $this->dbconnect_asterisk($db_host_name,$db_user_name,$db_password,$db_name);
		
		$sqlcnt="SELECT * FROM `cdr`";
		$resultcnt=mysqli_query($con,$sqlcnt);		
		$q_count = mysqli_num_rows($resultcnt);
		
		$page = ($action_arr[0]>0)?$action_arr[0]:1;
		$per_page = 20;
		$start = ($page*$per_page)-$per_page;
		
		$tot_page = ceil($q_count/$per_page);
		
		$order = 'desc';	
		$sql="SELECT * FROM `cdr`  ORDER BY  `calldate` ".$order." LIMIT ".$start.",".$per_page;
		$prev = (($page-1)>0)?($page-1):0;
		$next = (($page+1)<=$tot_page)?($page+1):0;
		$rec_arr = array();
		
		$result=mysqli_query($con,$sql);
		
		$asterisk_count = mysqli_num_rows($result); 
		
		if ($result)
		{
			while ($row=mysqli_fetch_assoc($result))
			{
				$rec_arr[] = $row;
			}
			// Free result set
			//mysqli_free_result($result);
		}		
		$call_details = $rec_arr;
		$paging_list ='';
				
        include(VIS_PATH_TEMPLATE.'asterisk_call_list.php');
		mysqli_close($con);
        return true;
    }
	function asterisk_call_details($operation){ 
		global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'voip.php');
		$voip_object=new class_voip($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        $vis_domain = $operation['vis_chk_domain'];
		$call_id = trim($action[4]);
		
		//include_once(VIS_PATH_PLUGINS.'aircall/class_aircall.php'); ##aircall integration	
	    //$obj_aircall	=	new class_aircall();	
		 
		$asterisk_filter='integration_type=51 AND is_enabled=1 AND domain_id='.$operation['vis_domain_id'];		
	    list($asterisk_count, $asterisk_details)=$object->get_integration_setting($asterisk_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);		
        $asterisk_details=$asterisk_details[0];
		
		
		$db_host_name	= $asterisk_details['host_name'];
		$db_user_name	= $asterisk_details['user_name'];
		$db_password	= $asterisk_details['db_password'];
		$db_name		= $asterisk_details['db_name'];
		$rec_url_path	= $asterisk_details['rec_path'];
		
		$con = $this->dbconnect_asterisk($db_host_name,$db_user_name,$db_password,$db_name);	
					
		$sql="SELECT * FROM `cdr` WHERE uniqueid='".$call_id."'";
		$rec_arr = array();
		
		$result=mysqli_query($con,$sql);		
		$asterisk_count = mysqli_num_rows($result); 		
		if ($result)
		{
			while ($row=mysqli_fetch_assoc($result))
			{
				$rec_arr[] = $row;
			}
			// Free result set
			//mysqli_free_result($result);
		}		
		$call_details = $rec_arr;		
		      
			if($asterisk_count<1) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
				return false;
			}else{				
				 include(VIS_PATH_TEMPLATE.'asterisk_call_details.php');
				}     
		
	}
	function dbconnect_asterisk($db_host_name,$db_user_name,$db_password,$db_name){
		$con=mysqli_connect($db_host_name,$db_user_name,$db_password,$db_name);
		// Check connection
		if (mysqli_connect_errno()) {
			echo "Failed to connect to MySQL: " . mysqli_connect_error();
		}
		// Change database to "test"
		//mysqli_select_db($con,$db_name);
		return $con;
	}
	function originate($operation){		
		global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		$filter = VIS_TABLE_PREFIX.'asterisk_dialplan.asterisk_id ='.$operation['vis_asterisk_id'].' AND intg.integration_type=51 AND (intg.integration_id='.$operation['vis_int_id'].') ';	
		list($number_count, $asterisk_dialpalns)=$object->get_asterisk_dialpalns($filter,'', '', ' order by intg.domain_id asc limit 0, 1 ', VIS_STAFF_ID, VIS_LOCATION_AREA);	
		$argv = array(1=>"84.94.213.75",2=> "5038",3=> "Yaacov", 4=>"y5784v",5=> "10000", 6=>"10000");
		include_once(VIS_PATH_PLUGINS.'asterisk/vendor/autoload.php'); ##load asterisk PAMI lib	
				
	}
	###Asterisk
}
?>
